/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: CanOpenAps_Public.h $
   Last Modification:
    $Author: Eric $
    $Modtime: 16.09.08 14:18 $
    $Revision: 5 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    CanOpen Aps
    public

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------

**************************************************************************************/
/**
 * @file CanOpenAps_Public.h
 *  CanOpen Aps - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__PACKED_PRE</code>
 * and <code>__PACKED_PRE</code> have to be added with the structural definition
 * in addition.
 */
#ifndef __CANOPEN_APS_PUBLIC_H
#define __CANOPEN_APS_PUBLIC_H

#include "CanOpenSlave_Public.h"

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__CANOPEN_APS_PUBLIC)
#endif

/*************************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'CanOpen Aps'.
 * Example for internal identification:<br>
 * @code
 * TLR_RESULT eRslt;
 * TLR_HANDLE hQue;
 * TLR_UINT   uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY_INTERN(
 *                                 CANOPEN_APS_QUEUE_NAME,
 *                                 uiInstance,
 *                                 &hQue
 *                                );
 * @endcode
 * <br>
 * Example for external or normal identification:<br>
 * @code
 * TLR_RESULT      eRslt;
 * TLR_QUE_LINK_T  tQue;
 * TLR_UINT        uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY(CANOPEN_APS_QUEUE_NAME, uiInstance, &tQue);
 * @endcode
 * <br>
 * @{
 */
/** queue name */
#define CANOPEN_APS_QUEUE_NAME        "QUE_CANOPENAPS"

/** @} */

/*-----------------------------------------------------------------------------------*/
/*------------------- General definitions -------------------------------------------*/
/*-----------------------------------------------------------------------------------*/
#define CANOPEN_APS_GET_STATE_REQ         0x00002E02L
#define CANOPEN_APS_GET_STATE_CNF         0x00002E03L

#define CANOPEN_APS_SET_CONFIGURATION_REQ 0x00002E04L
#define CANOPEN_APS_SET_CONFIGURATION_CNF 0x00002E05L

/*************************************************************************************/
/* packets */

/** @name Packet Data Definition
 *
 * The following defined structures represent the specific parameter
 * of the several services, which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>CANOPEN_APS_GET_STATE_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_APS_GET_STATE_CNF_DATA_Ttag
  CANOPEN_APS_GET_STATE_CNF_DATA_T;

__PACKED_PRE struct CANOPEN_APS_GET_STATE_CNF_DATA_Ttag
{
  TLR_UINT32 aulUnused[2];

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_APS_SET_CONFIGURATION_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_APS_SET_CONFIGURATION_REQ_DATA_Ttag
  CANOPEN_APS_SET_CONFIGURATION_REQ_DATA_T;

#define CANOPEN_APS_SYS_FLAG_COM_CONTROLLED_RELEASE 0x00000001L /* Automatic start    */
#define CANOPEN_APS_SYS_FLAG_IO_STATUS_ENABLED      0x00000002L /* Not supported      */
#define CANOPEN_APS_SYS_FLAG_IO_STATUS_32_BIT       0x00000004L /* Not supported      */

#define CANOPEN_APS_SYS_FLAG_ADDRESS_SWITCH         0x00000010L /* Switch for address */
#define CANOPEN_APS_SYS_FLAG_BAUD_SWITCH            0x00000020L /* Switch for baud    */

#define CANOPEN_APS_WD_OFF                          0x00000000L /* Watchdog disabled */
#define CANOPEN_APS_WD_MIN_TIMEOUT                  0x00000014L /* Minimum watchdog  */
#define CANOPEN_APS_WD_MAX_TIMEOUT                  0x0000FFFFL /* Maximum watchdog  */

__PACKED_PRE struct CANOPEN_APS_SET_CONFIGURATION_REQ_DATA_Ttag
{
  TLR_UINT32 ulSystemFlags;                /* System flags  */
  TLR_UINT32 ulWdgTime;                    /* Watchdog time */
  CANOPEN_SLAVE_BUSPARAM_DATA_T tBusParam; /* Bus parameter */

}__PACKED_POST;

/** @} */

/*************************************************************************************/
/** @name Packet Definition
 *
 * The following definied structures represent the packets of the several services,
 * which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>CANOPEN_APS_PCK_GET_STATE_REQ_Ttag</code> */
typedef struct CANOPEN_APS_PCK_GET_STATE_REQ_Ttag
  CANOPEN_APS_PCK_GET_STATE_REQ_T;
/** type of <code>CANOPEN_APS_PCK_GET_STATE_CNF_Ttag</code> */
typedef struct CANOPEN_APS_PCK_GET_STATE_CNF_Ttag
  CANOPEN_APS_PCK_GET_STATE_CNF_T;

__PACKED_PRE struct CANOPEN_APS_PCK_GET_STATE_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_APS_PCK_GET_STATE_CNF_Ttag
{
  TLR_PACKET_HEADER_T               tHead;   /** packet header */
  CANOPEN_APS_GET_STATE_CNF_DATA_T  tData;   /** packet data   */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_APS_SET_CONFIGURATION_REQ_Ttag</code> */
typedef struct CANOPEN_APS_SET_CONFIGURATION_REQ_Ttag
  CANOPEN_APS_SET_CONFIGURATION_REQ_T;
/** type of <code>CANOPEN_APS_SET_CONFIGURATION_CNF_Ttag</code> */
typedef struct CANOPEN_APS_SET_CONFIGURATION_CNF_Ttag
  CANOPEN_APS_SET_CONFIGURATION_CNF_T;

__PACKED_PRE struct CANOPEN_APS_SET_CONFIGURATION_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;  /** packet header */
  CANOPEN_APS_SET_CONFIGURATION_REQ_DATA_T  tData;  /** packet data   */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_APS_SET_CONFIGURATION_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header */

}__PACKED_POST;

/** @} */

/*************************************************************************************/

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__CANOPEN_APS_PUBLIC)
#endif

#endif /* #ifndef __CANOPEN_APS_PUBLIC_H */

/**************************************************************************************/
/*------------------------------------------------------------------------------------*/
/*---------------------------- EOF ---------------------------------------------------*/
/*------------------------------------------------------------------------------------*/
/**************************************************************************************/
